!function($){"use strict";var Typeahead=function(element,options){this.$element=$(element);this.options=$.extend(true,{},$.fn.typeahead.defaults,options);this.$menu=$(this.options.menu).appendTo('body');this.shown=false;this.eventSupported=this.options.eventSupported||this.eventSupported;this.grepper=this.options.grepper||this.grepper;this.highlighter=this.options.highlighter||this.highlighter;this.lookup=this.options.lookup||this.lookup;this.matcher=this.options.matcher||this.matcher;this.render=this.options.render||this.render;this.select=this.options.select||this.select;this.sorter=this.options.sorter||this.sorter;this.source=this.options.source||this.source;if(!this.source.length){var ajax=this.options.ajax;if(typeof ajax==='string'){this.ajax=$.extend({},$.fn.typeahead.defaults.ajax,{url:ajax});}else{this.ajax=$.extend({},$.fn.typeahead.defaults.ajax,ajax);}if(!this.ajax.url){this.ajax=null;}}this.listen();}
Typeahead.prototype={constructor:Typeahead,eventSupported:function(eventName){var isSupported=(eventName in this.$element);if(!isSupported){this.$element.setAttribute(eventName,'return;');isSupported=typeof this.$element[eventName]==='function';}return isSupported;},ajaxer:function(){var that=this,query=that.$element.val();if(query===that.query){return that;}that.query=query;if(that.ajax.timerId){clearTimeout(that.ajax.timerId);that.ajax.timerId=null;}if(!query||query.length<that.ajax.triggerLength){if(that.ajax.xhr){that.ajax.xhr.abort();that.ajax.xhr=null;that.ajaxToggleLoadClass(false);}return that.shown?that.hide():that;}that.ajax.timerId=setTimeout(function(){$.proxy(that.ajaxExecute(query),that)},that.ajax.timeout);return that;},ajaxExecute:function(query){this.ajaxToggleLoadClass(true);if(this.ajax.xhr)this.ajax.xhr.abort();var params=this.ajax.preDispatch?this.ajax.preDispatch(query):{query:query};var jAjax=(this.ajax.method==="post")?$.post:$.get;this.ajax.xhr=jAjax(this.ajax.url,params,$.proxy(this.ajaxLookup,this));this.ajax.timerId=null;},ajaxLookup:function(data){var items;this.ajaxToggleLoadClass(false);if(!this.ajax.xhr)return;if(this.ajax.preProcess){data=this.ajax.preProcess(data);}this.ajax.data=data;items=this.grepper(this.ajax.data);if(!items||!items.length){return this.shown?this.hide():this;}this.ajax.xhr=null;return this.render(items.slice(0,this.options.items)).show();},ajaxToggleLoadClass:function(enable){if(!this.ajax.loadingClass)return;this.$element.toggleClass(this.ajax.loadingClass,enable);},lookup:function(event){var that=this,items;if(that.ajax){that.ajaxer();}else{that.query=that.$element.val();if(!that.query){return that.shown?that.hide():that;}items=that.grepper(that.source);if(!items||!items.length){return that.shown?that.hide():that;}return that.render(items.slice(0,that.options.items)).show();}},grepper:function(data){var that=this,items;if(data&&data.length&&!data[0].hasOwnProperty(that.options.display)){return null;}items=$.grep(data,function(item){return that.matcher(item[that.options.display],item);});return this.sorter(items);},matcher:function(item){return~item.toLowerCase().indexOf(this.query.toLowerCase());},sorter:function(items){var that=this,beginswith=[],caseSensitive=[],caseInsensitive=[],item;while(item=items.shift()){if(!item[that.options.display].toLowerCase().indexOf(this.query.toLowerCase())){beginswith.push(item);}else if(~item[that.options.display].indexOf(this.query)){caseSensitive.push(item);}else{caseInsensitive.push(item);}}return beginswith.concat(caseSensitive,caseInsensitive);},show:function(){var pos=$.extend({},this.$element.offset(),{height:this.$element[0].offsetHeight});this.$menu.css({top:pos.top+pos.height,left:pos.left});this.$menu.show();this.shown=true;return this;},hide:function(){this.$menu.hide();this.shown=false;return this;},highlighter:function(item){var query=this.query.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,'\\$&');return item.replace(new RegExp('('+query+')','ig'),function($1,match){return'<strong>'+match+'</strong>';});},render:function(items){var that=this;items=$(items).map(function(i,item){i=$(that.options.item).attr('data-value',item[that.options.val]);i.find('a').html(that.highlighter(item[that.options.display],item));return i[0];});items.first().addClass('active');this.$menu.html(items);return this;},select:function(){var $selectedItem=this.$menu.find('.active');this.$element.val($selectedItem.text()).change();this.options.itemSelected($selectedItem,$selectedItem.attr('data-value'),$selectedItem.text());return this.hide();},next:function(event){var active=this.$menu.find('.active').removeClass('active');var next=active.next();if(!next.length){next=$(this.$menu.find('li')[0]);}next.addClass('active');},prev:function(event){var active=this.$menu.find('.active').removeClass('active');var prev=active.prev();if(!prev.length){prev=this.$menu.find('li').last();}prev.addClass('active');},listen:function(){this.$element.on('blur',$.proxy(this.blur,this)).on('keyup',$.proxy(this.keyup,this));if(this.eventSupported('keydown')){this.$element.on('keydown',$.proxy(this.keypress,this));}else{this.$element.on('keypress',$.proxy(this.keypress,this));}this.$menu.on('click',$.proxy(this.click,this)).on('mouseenter','li',$.proxy(this.mouseenter,this));},keyup:function(e){e.stopPropagation();e.preventDefault();switch(e.keyCode){case 40:case 38:break;case 9:case 13:if(!this.shown){return;}this.select();break;case 27:this.hide();break;default:this.lookup();}},keypress:function(e){e.stopPropagation();if(!this.shown){return;}switch(e.keyCode){case 9:case 13:case 27:e.preventDefault();break;case 38:e.preventDefault();this.prev();break;case 40:e.preventDefault();this.next();break;}},blur:function(e){var that=this;e.stopPropagation();e.preventDefault();setTimeout(function(){if(!that.$menu.is(':focus')){that.hide();}},150)},click:function(e){e.stopPropagation();e.preventDefault();this.select();},mouseenter:function(e){this.$menu.find('.active').removeClass('active');$(e.currentTarget).addClass('active');}}
$.fn.typeahead=function(option){return this.each(function(){var $this=$(this),data=$this.data('typeahead'),options=typeof option==='object'&&option;if(!data){$this.data('typeahead',(data=new Typeahead(this,options)));}if(typeof option==='string'){data[option]();}});}
$.fn.typeahead.defaults={source:[],items:8,menu:'<ul class="typeahead dropdown-menu"></ul>',item:'<li><a href="#"></a></li>',display:'name',val:'id',itemSelected:function(){},ajax:{url:null,timeout:300,method:'post',triggerLength:3,loadingClass:null,displayField:null,preDispatch:null,preProcess:null}}
$.fn.typeahead.Constructor=Typeahead;$(function(){$('body').on('focus.typeahead.data-api','[data-provide="typeahead"]',function(e){var $this=$(this);if($this.data('typeahead')){return;}e.preventDefault();$this.typeahead($this.data());})});}(window.jQuery);